% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_equator}
\alias{astro_equator}
\title{Topocentric equatorial coordinates of a celestial body}
\usage{
astro_equator(
  body,
  time,
  latitude,
  longitude,
  height = 0,
  equdate = FALSE,
  aberration = TRUE
)
}
\arguments{
\item{body}{Identifier of celestial body (e.g., \code{astro_body[["SUN"]]}, \code{astro_body[["MARS"]]}).
Must not be the Earth.}

\item{time}{A POSIXct time value.}

\item{latitude}{Observer's geographic latitude in degrees (positive north).}

\item{longitude}{Observer's geographic longitude in degrees (positive east).}

\item{height}{Observer's height in meters above sea level.}

\item{equdate}{One of \code{TRUE} (true-equator-of-date) or \code{FALSE} (J2000). Default is \code{FALSE}.}

\item{aberration}{One of \code{TRUE} (correct for aberration) or \code{FALSE}. Default is \code{TRUE}.}
}
\value{
A list with elements:
\describe{
\item{ra}{Right ascension in sidereal hours.}
\item{dec}{Declination in degrees.}
\item{dist}{Distance in AU.}
}
}
\description{
Calculates equatorial coordinates of a celestial body as seen by an observer on Earth's surface.
}
\details{
This function corrects for light travel time and topocentric parallax (the angular shift
depending on the observer's location on Earth). Parallax correction is most significant for
the Moon but has a small effect on other bodies.
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_equator(astro_body[["MARS"]], time, latitude = -33.87, longitude = 151.21)
}
