% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_geo_vector}
\alias{astro_geo_vector}
\title{Geocentric position vector of a celestial body}
\usage{
astro_geo_vector(body, time, aberration = "ABERRATION")
}
\arguments{
\item{body}{Identifier of celestial body (e.g., \code{astro_body["MERCURY"]}).}

\item{time}{A POSIXct time value.}

\item{aberration}{One of \code{"ABERRATION"} or \code{"NO_ABERRATION"}. Default is \code{"ABERRATION"}.}
}
\value{
A list with elements:
\describe{
\item{x}{X coordinate in AU.}
\item{y}{Y coordinate in AU.}
\item{z}{Z coordinate in AU.}
\item{time}{Observation time as POSIXct.}
}
}
\description{
Calculates the position of a celestial body as a vector using the center of the Earth
as the origin. The result is expressed as a Cartesian vector in the J2000 equatorial system
(the mean equator of the Earth at noon UTC on 1 January 2000).
}
\details{
This function corrects for light travel time. The position of the body is back-dated
by the amount of time it takes light to travel from that body to an observer on Earth.

The position can optionally be corrected for aberration, an effect causing the apparent
direction of the body to be shifted due to transverse movement of the Earth.
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_geo_vector(astro_body["MARS"], time)
}
