% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_helio_vector}
\alias{astro_helio_vector}
\title{Heliocentric position vector of a celestial body}
\usage{
astro_helio_vector(body, time)
}
\arguments{
\item{body}{Identifier of celestial body (e.g., \code{astro_body[["SUN"]]}, \code{astro_body[["MARS"]]}).}

\item{time}{A POSIXct time value.}
}
\value{
A list with elements:
\describe{
\item{x}{X coordinate in AU.}
\item{y}{Y coordinate in AU.}
\item{z}{Z coordinate in AU.}
\item{time}{Observation time as POSIXct.}
}
}
\description{
Calculates the position of a celestial body as a vector using the center of the Sun
as the origin. The result is expressed as a Cartesian vector in the J2000 equatorial system
(the mean equator of the Earth at noon UTC on 1 January 2000).
}
\details{
The position is not corrected for light travel time or aberration.
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_helio_vector(astro_body[["MARS"]], time)
}
