% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_horizon}
\alias{astro_horizon}
\title{Horizontal coordinates of a celestial body}
\usage{
astro_horizon(
  time,
  latitude,
  longitude,
  ra,
  dec,
  refraction = "REFRACTION_NORMAL"
)
}
\arguments{
\item{time}{A POSIXct time value.}

\item{latitude}{Observer's geographic latitude in degrees (positive north).}

\item{longitude}{Observer's geographic longitude in degrees (positive east).}

\item{ra}{Right ascension of the body in sidereal hours.}

\item{dec}{Declination of the body in degrees.}

\item{refraction}{One of \code{"REFRACTION_NORMAL"}, \code{"REFRACTION_JPLHOR"}, or \code{"REFRACTION_NONE"}.}
}
\value{
A list with elements:
\describe{
\item{azimuth}{Azimuth angle in degrees (eastward from north).}
\item{altitude}{Altitude angle in degrees (positive above horizon).}
\item{ra}{Right ascension of the body in sidereal hours.}
\item{dec}{Declination of the body in degrees.}
}
}
\description{
Calculates the apparent location of a body relative to the local horizon of an observer on Earth.
}
\details{
Given a date, time, geographic location, and equatorial coordinates of a celestial body,
this function returns horizontal coordinates (azimuth and altitude) relative to the horizon.

The \code{ra} and \code{dec} must be equator-of-date coordinates. Equator-of-date coordinates can be
obtained by calling \code{\link[=astro_equator]{astro_equator()}} with \code{equdate = "EQUATOR_OF_DATE"} and
\code{aberration = "ABERRATION"}.

Atmospheric refraction correction is recommended. Pass \code{refraction = "REFRACTION_NORMAL"}
to correct for optical lensing of the Earth's atmosphere that causes objects to appear
higher above the horizon than they actually are.
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_horizon(time, latitude = -33.87, longitude = 151.21, ra = 10.5, dec = -20.0)
}
