% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rise_set_culmination.R
\name{astro_hour_angle}
\alias{astro_hour_angle}
\title{Calculate the hour angle of a body}
\usage{
astro_hour_angle(body, time, latitude, longitude, height = 0)
}
\arguments{
\item{body}{Integer body code (see \link{astro_body}).}

\item{time}{A \code{POSIXct} date/time in UTC.}

\item{latitude}{Observer's geographic latitude in degrees.}

\item{longitude}{Observer's geographic longitude in degrees.}

\item{height}{Observer's height above sea level in metres. Default \code{0}.}
}
\value{
A numeric value representing the hour angle in the range [0, 24),
where each unit is one sidereal hour.
}
\description{
Finds the hour angle of a body for a given observer and time. The hour angle
indicates the body's position in the sky with respect to Earth's rotation.
}
\details{
The hour angle is 0 when the body culminates (reaches its highest point),
and increases by 1 unit for every sidereal hour that passes. A value of 12
means the body is at its lowest point. A value of 24 is equivalent to 0.
}
\examples{
t <- as.POSIXct("2025-06-21 12:00:00", tz = "UTC")
astro_hour_angle(astro_body[["SUN"]], t,
                 latitude = -33.8688, longitude = 151.2093)
}
