% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual.R
\name{astro_illumination}
\alias{astro_illumination}
\title{Illumination data for a celestial body}
\usage{
astro_illumination(body, time)
}
\arguments{
\item{body}{An integer representing a celestial body (see \verb{[astro_body]}).
Cannot be Earth.}

\item{time}{A \code{POSIXct} datetime object.}
}
\value{
A list containing:
\describe{
\item{time}{The input time as a \code{POSIXct} object.}
\item{mag}{Visual magnitude (numeric).}
\item{phase_angle}{Phase angle in degrees (numeric).}
\item{phase_fraction}{Fraction of the body illuminated from 0 to 1 (numeric).}
\item{helio_dist}{Distance from Sun in AU (numeric).}
\item{ring_tilt}{Saturn's ring tilt in degrees, 0 for other bodies (numeric).}
}
}
\description{
Calculates visual magnitude, phase angle, and related illumination information
for a celestial body as seen from Earth.
}
\details{
Visual magnitude is a measure of brightness, where smaller (or negative) values
indicate brighter objects and larger values indicate dimmer objects.

Phase angle is the angle in degrees between the Sun and Earth as seen from the
body's center. It indicates what fraction of the body appears illuminated from Earth:
\itemize{
\item Phase angle near 0° means the body appears "full"
\item Phase angle near 90° means the body appears "half full"
\item Phase angle near 180° means the body appears as a thin crescent
}

For Saturn, the returned list includes \code{ring_tilt}, which is the tilt angle
in degrees of Saturn's rings as seen from Earth (0° means edge-on and nearly invisible).
}
\examples{
# Get illumination data for Mars on 2025-06-21
time <- as.POSIXct("2025-06-21", tz = "UTC")
astro_illumination(astro_body["MARS"], time)
}
