% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{astro_next_lunar_eclipse}
\alias{astro_next_lunar_eclipse}
\title{Find the next lunar eclipse in a series}
\usage{
astro_next_lunar_eclipse(prev_eclipse_time)
}
\arguments{
\item{prev_eclipse_time}{A \code{POSIXct} time near a lunar eclipse peak
(typically from a previous call).}
}
\value{
A list with the following elements:
\describe{
\item{kind}{Integer code for eclipse type (0=penumbral, 1=partial, 2=total).}
\item{obscuration}{Fraction of Moon's disc covered by Earth's umbra (0-1).}
\item{peak}{POSIXct time of eclipse peak.}
\item{sd_total}{Semi-duration of total phase in minutes.}
\item{sd_partial}{Semi-duration of partial phase in minutes.}
\item{sd_penum}{Semi-duration of penumbral phase in minutes.}
}
}
\description{
After using \code{\link[=astro_search_lunar_eclipse]{astro_search_lunar_eclipse()}} to find the first lunar eclipse,
call this function to find the next consecutive lunar eclipse.
Pass in the \code{peak} value from the previous call.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
first_eclipse <- astro_search_lunar_eclipse(start)
next_eclipse <- astro_next_lunar_eclipse(first_eclipse$peak)
}
