% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonphase.R
\name{astro_next_moon_quarter}
\alias{astro_next_moon_quarter}
\title{Find Next Lunar Quarter}
\usage{
astro_next_moon_quarter(mq)
}
\arguments{
\item{mq}{A list returned by \code{\link[=astro_search_moon_quarter]{astro_search_moon_quarter()}} or a previous
call to \code{astro_next_moon_quarter()}.}
}
\value{
A list with:
\describe{
\item{quarter}{Integer 0-3: 0 = new moon, 1 = first quarter, 2 = full moon, 3 = third quarter.}
\item{time}{POSIXct datetime of the next lunar quarter.}
}
}
\description{
Continues searching for lunar quarters from a previous search result.
Call this function repeatedly after \code{\link[=astro_search_moon_quarter]{astro_search_moon_quarter()}} to
find consecutive lunar quarters.
}
\examples{
start <- as.POSIXct("2025-02-19", tz = "UTC")
q1 <- astro_search_moon_quarter(start)
q2 <- astro_next_moon_quarter(q1)
q3 <- astro_next_moon_quarter(q2)
}
