% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{astro_next_transit}
\alias{astro_next_transit}
\title{Search for the next transit of Mercury or Venus}
\usage{
astro_next_transit(body, prev_transit_time)
}
\arguments{
\item{body}{Integer code for the planet. Use \code{1} for Mercury or \code{2} for Venus.}

\item{prev_transit_time}{A \code{POSIXct} datetime from a previous transit result.}
}
\value{
A list with elements:
\describe{
\item{start}{Start time of the transit (POSIXct).}
\item{peak}{Time of closest approach (POSIXct).}
\item{finish}{End time of the transit (POSIXct).}
\item{separation}{Angular separation at peak in arcminutes.}
}
}
\description{
Finds the next transit of Mercury or Venus after a previous transit.
Call this repeatedly to find successive transits.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
transit1 <- astro_search_transit(astro_body["MERCURY"], start)
transit2 <- astro_next_transit(astro_body["MERCURY"], transit1$peak)
}
