% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_pivot}
\alias{astro_pivot}
\title{Re-orient a rotation matrix by pivoting around an axis}
\usage{
astro_pivot(rotation, axis, angle)
}
\arguments{
\item{rotation}{The input rotation matrix}

\item{axis}{An integer that selects which coordinate axis to rotate around:
0 = x, 1 = y, 2 = z. Any other value will fail with an error.}

\item{angle}{An angle in degrees indicating the amount of rotation around the specified axis.
Positive angles indicate rotation counterclockwise as seen from the positive
direction along that axis, looking towards the origin point of the orientation system.
Any finite number of degrees is allowed, but best precision will result from keeping
\code{angle} in the range [-360, +360].}
}
\value{
A pivoted rotation matrix
}
\description{
Given a rotation matrix, a selected coordinate axis, and an angle in degrees,
this function pivots the rotation matrix by that angle around that coordinate
axis.
}
\details{
For example, if you have rotation matrix that converts ecliptic coordinates (ECL)
to horizontal coordinates (HOR), but you really want to convert ECL to the orientation
of a telescope camera pointed at a given body, you can use \code{astro_pivot()} twice:
(1) pivot around the zenith axis by the body's azimuth, then (2) pivot around the
western axis by the body's altitude angle. The resulting rotation matrix will then
reorient ECL coordinates to the orientation of your telescope camera.
}
\examples{
# Create an identity matrix and pivot it
rot <- astro_identity_matrix()
pivoted <- astro_pivot(rot, axis = 2, angle = 45)  # Rotate 45° around z-axis
}
