% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_ECL_EQD}
\alias{astro_rotation_ECL_EQD}
\title{Rotation Matrix from J2000 Ecliptic to Equatorial of-Date}
\usage{
astro_rotation_ECL_EQD(time)
}
\arguments{
\item{time}{A POSIXct object representing the date and time.}
}
\value{
A rotation matrix that converts ECL to EQD.
}
\description{
Calculates a rotation matrix from J2000 mean ecliptic (ECL) to equatorial
of-date (EQD).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: ECL = ecliptic system, using equator at J2000 epoch.

\strong{Target}: EQD = equatorial system, using equator of date.
}
\examples{
astro_rotation_ECL_EQD(Sys.time())

}
