% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_ECT_EQJ}
\alias{astro_rotation_ECT_EQJ}
\title{Rotation Matrix from ECT to EQJ}
\usage{
astro_rotation_ECT_EQJ(time)
}
\arguments{
\item{time}{A POSIXct object representing the date and time at which the Earth's
ecliptic defines the source orientation.}
}
\value{
A rotation matrix that converts ECT to EQJ.
}
\description{
Calculates a rotation matrix from true ecliptic of date (ECT) to J2000 mean
equator (EQJ).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: ECT = ecliptic system, using true equinox of the specified date/time.

\strong{Target}: EQJ = equatorial system, using mean equator at J2000 epoch.
}
\examples{
astro_rotation_ECT_EQJ(Sys.time())

}
