% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_EQJ_ECT}
\alias{astro_rotation_EQJ_ECT}
\title{Rotation Matrix from EQJ to ECT}
\usage{
astro_rotation_EQJ_ECT(time_posix)
}
\arguments{
\item{time_posix}{A POSIXct object specifying the date and time at which the Earth's equator
defines the target orientation.}
}
\value{
A rotation matrix that converts EQJ to ECT at the specified time.
}
\description{
Calculates a rotation matrix from J2000 mean equator (EQJ) to true ecliptic
of date (ECT).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: EQJ = equatorial system, using mean equator at J2000 epoch.

\strong{Target}: ECT = ecliptic system, using true equinox of the specified date/time.
}
\examples{
time <- as.POSIXct("2024-01-01", tz = "UTC")
astro_rotation_EQJ_ECT(time)

}
