% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_HOR_ECL}
\alias{astro_rotation_HOR_ECL}
\title{Rotation Matrix from HOR to ECL}
\usage{
astro_rotation_HOR_ECL(time, latitude, longitude, height)
}
\arguments{
\item{time}{A POSIXct object representing the date and time of observation.}

\item{latitude}{The observer's geographic latitude in degrees.}

\item{longitude}{The observer's geographic longitude in degrees.}

\item{height}{The observer's elevation above sea level in meters.}
}
\value{
A rotation matrix that converts HOR to ECL.
}
\description{
Calculates a rotation matrix from horizontal (HOR) to J2000 mean ecliptic (ECL).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: HOR = horizontal system (x = north, y = west, z = zenith).

\strong{Target}: ECL = ecliptic system, using equator at J2000 epoch.
}
\examples{
astro_rotation_HOR_ECL(Sys.time(), latitude = -35.28, longitude = 149.12, height = 0)

}
