% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_HOR_EQJ}
\alias{astro_rotation_HOR_EQJ}
\title{Rotation Matrix from Horizontal to J2000 Equatorial}
\usage{
astro_rotation_HOR_EQJ(time, latitude, longitude, height)
}
\arguments{
\item{time}{A POSIXct object representing the date and time of observation.}

\item{latitude}{The observer's geographic latitude in degrees.}

\item{longitude}{The observer's geographic longitude in degrees.}

\item{height}{The observer's elevation above sea level in meters.}
}
\value{
A rotation matrix that converts HOR to EQJ at \code{time} and for the observer.
}
\description{
Calculates a rotation matrix from horizontal (HOR) to J2000 mean equator (EQJ).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: HOR = horizontal system (x=North, y=West, z=Zenith).

\strong{Target}: EQJ = equatorial system, using equator at J2000 epoch.
}
\examples{
astro_rotation_HOR_EQJ(Sys.time(), latitude = -35.28, longitude = 149.12, height = 0)

}
