% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rise_set_culmination.R
\name{astro_search_altitude}
\alias{astro_search_altitude}
\title{Search for when a body reaches a specified altitude}
\usage{
astro_search_altitude(
  body,
  time,
  latitude,
  longitude,
  height = 0,
  direction = 1L,
  limit_days = 1,
  altitude = 0
)
}
\arguments{
\item{body}{Integer body code (see \link{astro_body}).}

\item{time}{A \code{POSIXct} date/time in UTC to start the search from.}

\item{latitude}{Observer's geographic latitude in degrees.}

\item{longitude}{Observer's geographic longitude in degrees.}

\item{height}{Observer's height above sea level in metres. Default \code{0}.}

\item{direction}{\code{1L} to find the body ascending, \code{-1L} to find descending.
Default \code{1L} (ascending).}

\item{limit_days}{Maximum number of days to search. When positive, searches
forward in time; when negative, searches backward. Default \code{1}.}

\item{altitude}{The desired altitude angle above (positive) or below (negative)
the observer's local horizon, in degrees. Must be in the range [-90, +90].}
}
\value{
A \code{POSIXct} value in UTC, or \code{NA} if no event is found within
\code{limit_days}.
}
\description{
Finds when the center of a given body ascends or descends through a given
altitude angle, as seen by an observer at the specified location on the Earth.
}
\details{
This function is useful for finding twilight times. For example:
\itemize{
\item Civil dawn: \verb{direction = 1, altitude = -6}
\item Civil dusk: \verb{direction = -1, altitude = -6}
\item Nautical twilight: \code{altitude = -12}
\item Astronomical twilight: \code{altitude = -18}
}
}
\examples{
t <- as.POSIXct("2025-06-21", tz = "UTC")
# Find civil dawn (Sun at -6 degrees)
astro_search_altitude(astro_body[["SUN"]], t,
                      latitude = -33.8688, longitude = 151.2093,
                      direction = 1L, altitude = -6)
}
