% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rise_set_culmination.R
\name{astro_search_hour_angle}
\alias{astro_search_hour_angle}
\title{Search for when a body reaches a specified hour angle}
\usage{
astro_search_hour_angle(
  body,
  time,
  latitude,
  longitude,
  height = 0,
  hour_angle = 0,
  direction = 1L
)
}
\arguments{
\item{body}{Integer body code (see \link{astro_body}).}

\item{time}{A \code{POSIXct} date/time in UTC to start the search from.}

\item{latitude}{Observer's geographic latitude in degrees.}

\item{longitude}{Observer's geographic longitude in degrees.}

\item{height}{Observer's height above sea level in metres. Default \code{0}.}

\item{hour_angle}{An hour angle value in the range [0, 24) indicating the
number of sidereal hours after the body's most recent culmination.
Default \code{0} (culmination).}

\item{direction}{\code{1L} to search forward in time, \code{-1L} to search backward.
Default \code{1L} (forward).}
}
\value{
A list with elements:
\describe{
\item{time}{\code{POSIXct} time of the event.}
\item{azimuth}{Azimuth angle in degrees (0° = North, 90° = East).}
\item{altitude}{Altitude angle in degrees above the horizon.}
}
}
\description{
Searches for the time when the center of a body reaches a specified hour
angle as seen by an observer on the Earth. The hour angle is 0 when the body
reaches its highest point (culmination) above the horizon in a given day.
}
\details{
To find when a body culminates (reaches maximum altitude), use \code{hour_angle = 0}.
To find when a body reaches its minimum altitude, use \code{hour_angle = 12}.
}
\examples{
t <- as.POSIXct("2025-06-21", tz = "UTC")
# Find when the Sun culminates (hour_angle = 0)
astro_search_hour_angle(astro_body[["SUN"]], t,
                        latitude = -33.8688, longitude = 151.2093)
}
