% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{astro_search_lunar_eclipse}
\alias{astro_search_lunar_eclipse}
\title{Search for a lunar eclipse}
\usage{
astro_search_lunar_eclipse(start_time)
}
\arguments{
\item{start_time}{A \code{POSIXct} date and time for starting the search.}
}
\value{
A list with the following elements:
\describe{
\item{kind}{Integer code for eclipse type (0=penumbral, 1=partial, 2=total).}
\item{obscuration}{Fraction of Moon's disc covered by Earth's umbra (0-1).}
\item{peak}{POSIXct time of eclipse peak.}
\item{sd_total}{Semi-duration of total phase in minutes.}
\item{sd_partial}{Semi-duration of partial phase in minutes.}
\item{sd_penum}{Semi-duration of penumbral phase in minutes.}
}
}
\description{
Searches for the first lunar eclipse that occurs after the given start time.
A lunar eclipse may be penumbral, partial, or total.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
astro_search_lunar_eclipse(start)
}
