% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual.R
\name{astro_search_max_elongation}
\alias{astro_search_max_elongation}
\title{Search for maximum elongation}
\usage{
astro_search_max_elongation(body, start_time)
}
\arguments{
\item{body}{Integer code for the celestial body. Must be Mercury (3) or
Venus (2). Other values will fail.}

\item{start_time}{A POSIXct date-time value indicating the search start time.
The maximum elongation event found will be the first one occurring after
this time.}
}
\value{
A list with the following elements:
\describe{
\item{visibility}{Integer flag indicating morning (0) or evening (1)
visibility.}
\item{elongation}{The maximum elongation angle in degrees.}
\item{ecliptic_separation}{The ecliptic separation at maximum elongation.}
\item{time}{A POSIXct value representing the time of maximum elongation.}
\item{status}{Status code from the underlying C function.}
}
}
\description{
Finds the next date and time when Mercury or Venus reaches its maximum angle
from the Sun as seen from the Earth. Maximum elongation events are the best
opportunities for observing these inner planets.
}
\examples{
start <- as.POSIXct("2025-01-01 00:00:00", tz = "UTC")
astro_search_max_elongation(body = astro_body["MERCURY"], start_time = start)
}
