% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonphase.R
\name{astro_search_moon_quarter}
\alias{astro_search_moon_quarter}
\title{Find First Lunar Quarter}
\usage{
astro_search_moon_quarter(start_time)
}
\arguments{
\item{start_time}{A POSIXct datetime to begin the search.}
}
\value{
A list with:
\describe{
\item{quarter}{Integer 0-3: 0 = new moon, 1 = first quarter, 2 = full moon, 3 = third quarter.}
\item{time}{POSIXct datetime of the lunar quarter.}
}
}
\description{
Finds the first lunar quarter (new moon, first quarter, full moon, or
third quarter) after the specified date and time.
}
\examples{
start <- as.POSIXct("2025-02-19", tz = "UTC")
astro_search_moon_quarter(start)
}
