% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual.R
\name{astro_search_peak_magnitude}
\alias{astro_search_peak_magnitude}
\title{Search for peak magnitude of Venus}
\usage{
astro_search_peak_magnitude(body, start_time)
}
\arguments{
\item{body}{An integer representing the celestial body. Currently only
\code{astro_body["VENUS"]} is supported. Returns error for other bodies.}

\item{start_time}{A \code{POSIXct} datetime object specifying when to begin
the search.}
}
\value{
A list containing:
\describe{
\item{time}{The time of peak magnitude as a \code{POSIXct} object.}
\item{mag}{Visual magnitude at peak brightness (numeric).}
\item{phase_angle}{Phase angle in degrees (numeric).}
\item{phase_fraction}{Fraction of Venus illuminated (numeric).}
\item{helio_dist}{Distance from Sun in AU (numeric).}
\item{ring_tilt}{Always 0 for Venus (numeric).}
}
}
\description{
Searches for the next date and time when Venus will appear brightest as seen
from Earth. This function currently only supports Venus.
}
\details{
Venus reaches peak magnitude (maximum brightness) at certain times in its orbit.
This is distinct from other brightness events: Mercury's peak magnitude occurs
at superior conjunction when it's invisible, and outer planets reach peak magnitude
at opposition.

The search may require iterating through multiple synodic periods of Venus
to find an event after the specified start time. The function will search
forward from the start time until it finds a valid peak magnitude event.
}
\examples{
# Find when Venus will next reach peak magnitude after 2025-01-01
start <- as.POSIXct("2025-01-01", tz = "UTC")
astro_search_peak_magnitude(astro_body["VENUS"], start)
}
