% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{astro_search_transit}
\alias{astro_search_transit}
\title{Search for a transit of Mercury or Venus}
\usage{
astro_search_transit(body, start_time)
}
\arguments{
\item{body}{Integer code for the planet. Use \code{1} for Mercury or \code{2} for Venus.}

\item{start_time}{A \code{POSIXct} datetime for starting the search.}
}
\value{
A list with elements:
\describe{
\item{start}{Start time of the transit (POSIXct).}
\item{peak}{Time of closest approach (POSIXct).}
\item{finish}{End time of the transit (POSIXct).}
\item{separation}{Angular separation at peak in arcminutes.}
}
}
\description{
Finds the first transit of Mercury or Venus after a specified date.
A transit occurs when an inferior planet passes between the Sun and Earth,
with the planet's silhouette visible against the Sun.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
astro_search_transit(astro_body["MERCURY"], start)
}
