% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solar_motion.R
\name{astro_seasons}
\alias{astro_seasons}
\title{Equinoxes and Solstices for a Given Year}
\usage{
astro_seasons(year)
}
\arguments{
\item{year}{Integer calendar year. While any integer is accepted, only the years
1800 through 2100 have been validated for accuracy. Unit testing against data
from the United States Naval Observatory confirms that all equinoxes and
solstices for this range are within 2 minutes of the correct time.}
}
\value{
A list of \code{POSIXct} values (in UTC):
\describe{
\item{mar_equinox}{March equinox.}
\item{jun_solstice}{June solstice.}
\item{sep_equinox}{September equinox.}
\item{dec_solstice}{December solstice.}
}
}
\description{
Calculates the dates and times of both equinoxes and both solstices for a
given calendar year.
}
\details{
The equinoxes are the moments twice each year when the plane of the
Earth's equator passes through the center of the Sun. In other words,
the Sun's declination is zero at both equinoxes.
The March equinox defines the beginning of spring in the northern hemisphere
and the beginning of autumn in the southern hemisphere.
The September equinox defines the beginning of autumn in the northern hemisphere
and the beginning of spring in the southern hemisphere.

The solstices are the moments twice each year when one of the Earth's poles
is most tilted toward the Sun. More precisely, the Sun's declination reaches
its minimum value at the December solstice, which defines the beginning of
winter in the northern hemisphere and the beginning of summer in the southern
hemisphere. The Sun's declination reaches its maximum value at the June solstice,
which defines the beginning of summer in the northern hemisphere and the beginning
of winter in the southern hemisphere.
}
\examples{
astro_seasons(2025)
}
