% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R, R/rotation.R
\name{astro_sphere_from_vector}
\alias{astro_sphere_from_vector}
\title{Convert Cartesian Vector to Spherical Coordinates}
\usage{
astro_sphere_from_vector(vector)

astro_sphere_from_vector(vector)
}
\arguments{
\item{vector}{A list with components:
\describe{
\item{x}{The Cartesian x-coordinate in AU}
\item{y}{The Cartesian y-coordinate in AU}
\item{z}{The Cartesian z-coordinate in AU}
\item{t}{The date and time (POSIXct) at which this vector is valid}
}}
}
\value{
A list representing spherical coordinates with elements:
\itemize{
\item \code{lat}: Latitude in degrees
\item \code{lon}: Longitude in degrees (0-360)
\item \code{dist}: Distance in AU
\item \code{status}: Status code (0 = success)
}

A list with components:
\describe{
\item{lat}{Latitude angle: -90..+90 degrees}
\item{lon}{Longitude angle: 0..360 degrees}
\item{dist}{Distance in AU}
\item{status}{Status code (0 = success)}
}
}
\description{
Given a Cartesian vector, returns latitude, longitude, and distance
in spherical coordinates.

Given a Cartesian vector, returns latitude, longitude, and distance.
}
\examples{
vec <- list(x = 1, y = 1, z = 1, t = as.POSIXct("2024-01-01", tz = "UTC"))
sphere <- astro_sphere_from_vector(vec)

# Convert Cartesian to spherical
vec <- list(x = 1, y = 0, z = 0, t = as.POSIXct("2024-01-01", tz = "UTC"))
sphere <- astro_sphere_from_vector(vec)
}
