% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R, R/rotation.R
\name{astro_vector_from_horizon}
\alias{astro_vector_from_horizon}
\title{Convert Horizontal Coordinates to Cartesian Vector}
\usage{
astro_vector_from_horizon(sphere, time, refraction = 1L)

astro_vector_from_horizon(sphere, time, refraction = 1L)
}
\arguments{
\item{sphere}{A list with components:
\describe{
\item{lat}{Refracted altitude angle in degrees}
\item{lon}{Azimuth in degrees clockwise from north}
\item{dist}{Distance from the observer to the object in AU}
}}

\item{time}{POSIXct time of the observation}

\item{refraction}{Refraction option (0 = REFRACTION_NONE, 1 = REFRACTION_NORMAL, 2 = REFRACTION_JPLHOR).
This specifies how refraction is to be removed from the altitude stored in \code{sphere$lat}.}
}
\value{
A list representing a horizontal Cartesian vector with elements:
\itemize{
\item \code{x}: North component in AU
\item \code{y}: West component in AU
\item \code{z}: Zenith (up) component in AU
\item \code{t}: Time value
\item \code{status}: Status code (0 = success)
}

A list representing a vector in the horizontal system with components:
\describe{
\item{x}{North component in AU}
\item{y}{West component in AU}
\item{z}{Zenith (up) component in AU}
\item{t}{The date and time (POSIXct)}
\item{status}{Status code (0 = success)}
}
}
\description{
Given apparent angular horizontal coordinates, calculates a horizontal
Cartesian vector.

Given apparent angular horizontal coordinates, calculate horizontal vector.
The input azimuth is measured in degrees clockwise from north (east = +90).
The returned vector is in the horizontal system: x = north, y = west, z = zenith (up).
}
\examples{
# 30° altitude, facing south
hor <- list(lat = 30, lon = 180, dist = 1)
time <- as.POSIXct("2024-01-01 12:00:00", tz = "UTC")
vec <- astro_vector_from_horizon(hor, time, refraction = 1)

# Convert horizontal coordinates to vector
sphere <- list(lat = 45, lon = 90, dist = 1)  # 45° altitude, 90° azimuth (east)
time <- as.POSIXct("2024-01-01 12:00:00", tz = "UTC")
vec <- astro_vector_from_horizon(sphere, time, refraction = 1)
}
