% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{search_global_solar_eclipse}
\alias{search_global_solar_eclipse}
\title{Search for a global solar eclipse}
\usage{
search_global_solar_eclipse(start_time)
}
\arguments{
\item{start_time}{A \code{POSIXct} date/time for starting the search.}
}
\value{
A list containing:
\describe{
\item{status}{Status code (0 = success).}
\item{kind}{Type of eclipse: 0 = partial, 1 = annular, 2 = total.}
\item{peak}{Peak time of the eclipse as \code{POSIXct}.}
\item{distance}{Distance in kilometers from Earth's center to Moon's shadow axis.}
\item{latitude}{Latitude of peak eclipse.}
\item{longitude}{Longitude of peak eclipse.}
}
}
\description{
Searches for the first solar eclipse visible anywhere on Earth's surface
that occurs after the given start time. A solar eclipse may be partial,
annular, or total. To find a series of eclipses, use \code{next_global_solar_eclipse}
with the \code{peak} time from the previous result.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
search_global_solar_eclipse(start)
}
