% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_counter_increment}
\alias{am_counter_increment}
\title{Increment a counter value}
\usage{
am_counter_increment(doc, obj, key, delta)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (map or list), or \code{AM_ROOT} for the document root}

\item{key}{For maps: a character string key. For lists: an integer index (1-based)}

\item{delta}{Integer value to add to the counter (can be negative)}
}
\value{
The document (invisibly), allowing for chaining with pipes
}
\description{
Increments an Automerge counter by the specified delta. Counters are CRDT types
that support concurrent increments from multiple actors. Unlike regular integers,
counter increments are commutative and do not conflict when merged.
}
\details{
The delta can be negative to decrement the counter.
}
\examples{
# Counter in document root (map)
doc <- am_create()
doc$score <- am_counter(0)
am_counter_increment(doc, AM_ROOT, "score", 10)
doc$score  # 10

am_counter_increment(doc, AM_ROOT, "score", 5)
doc$score  # 15

# Decrement with negative delta
am_counter_increment(doc, AM_ROOT, "score", -3)
doc$score  # 12

# Counter in a nested map
doc$stats <- am_map(views = am_counter(0))
stats_obj <- doc$stats
am_counter_increment(doc, stats_obj, "views", 100)

# Counter in a list (1-based indexing)
doc$counters <- list(am_counter(0), am_counter(5))
counters_obj <- doc$counters
am_counter_increment(doc, counters_obj, 1, 1)  # Increment first counter
am_counter_increment(doc, counters_obj, 2, 2)  # Increment second counter
}
