% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_snapshot}
\alias{ec2_create_snapshot}
\title{Create Snapshot}
\usage{
ec2_create_snapshot(
  VolumeId,
  Description = NULL,
  OutpostArn = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{VolumeId}{Character. The ID of the EBS volume.}

\item{Description}{Character. A description for the snapshot.[optional]}

\item{OutpostArn}{Character.   The Amazon Resource Name (ARN) of the AWS Outpost on which to create a local snapshot.[optional]}

\item{TagSpecification}{List. The tags to apply to the snapshot during creation.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Snapshot
}
\section{VolumeId}{

The ID of the EBS
volume.
}

\section{Description}{

A description for the
snapshot.
}

\section{OutpostArn}{


The Amazon Resource Name (ARN) of the AWS Outpost on which to create a
local snapshot.
\itemize{
\item To create a snapshot of a volume in a Region, omit this parameter.
The snapshot is created in the same Region as the volume.
\item To create a snapshot of a volume on an Outpost and store the
snapshot in the Region, omit this parameter. The snapshot is created
in the Region for the Outpost.
\item To create a snapshot of a volume on an Outpost and store the
snapshot on an Outpost, specify the ARN of the destination Outpost.
The snapshot must be created on the same Outpost as the volume.
}

For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot}{Creating local snapshots from volumes on an Outpost}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{TagSpecification}{

The tags to apply to the snapshot during
creation.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

