% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_update_service_primary_task_set}
\alias{ecs_update_service_primary_task_set}
\title{Update Service Primary Task Set}
\usage{
ecs_update_service_primary_task_set(
  cluster = NULL,
  service = NULL,
  primaryTaskSet = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the...}

\item{service}{Character. The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.}

\item{primaryTaskSet}{Character. The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set...}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modifies which task set in a service is the primary
task set. Any parameters that are updated on the primary task set in a
service will transition to the service. This is used when a service uses
the \code{EXTERNAL} deployment controller type. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-services.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}
\section{cluster}{

The short name or
full Amazon Resource Name (ARN) of the cluster that hosts the service
that the task set exists in.
}

\section{service}{

The short name or full
Amazon Resource Name (ARN) of the service that the task set exists
in.
}

\section{primaryTaskSet}{

The short name or full Amazon Resource Name
(ARN) of the task set to set as the primary task set in the
deployment.
}

