% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_and_apply_delay.R
\name{estimate_and_apply_delays}
\alias{estimate_and_apply_delays}
\title{Estimate and apply delays to generate retrospective nowcasts}
\usage{
estimate_and_apply_delays(
  retro_reporting_triangles,
  n = min(sapply(retro_reporting_triangles, nrow)),
  delay_pmf = NULL,
  validate = TRUE
)
}
\arguments{
\item{retro_reporting_triangles}{List of reporting triangles to generate
nowcasts for. Typically created by \code{\link[=apply_reporting_structures]{apply_reporting_structures()}}.}

\item{n}{Integer indicating the number of reference times
(number of rows) to use to estimate the delay distribution for each
reporting triangle. Default is the minimum of the number of rows of
all the matrices in \code{retro_reporting_triangles}.}

\item{delay_pmf}{Vector or list of vectors of delays assumed to be indexed
starting at the first delay column in each of the matrices in
\code{retro_reporting_triangles}. If a list, must be of the same length as
\code{retro_reporting_triangles}, with elements aligning. Default is \code{NULL}.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
\code{point_nowcast_matrices} List of the same number of elements as
the input \code{retro_reporting_triangles} but with each reporting triangle
filled in based on the delay estimated in that reporting triangle.
}
\description{
This function ingests a list of incomplete reporting triangles and
generates a list of point nowcast matrices, based on the delay estimated
in each triangle or the corresponding delay passed in. It uses the
specified \code{n} number of reference times to estimate the delay in each
retrospective reporting triangle.
}
\examples{
# Generate retrospective nowcasts using larger triangle
data_as_of <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data_as_of) |>
  truncate_to_delay(max_delay = 25) |>
  tail(n = 50)
trunc_rts <- truncate_to_rows(rep_tri, n = 2)
retro_rts <- apply_reporting_structures(trunc_rts)
retro_pt_nowcast_mat_list <- estimate_and_apply_delays(retro_rts, n = 30)
retro_pt_nowcast_mat_list[1:2]

# Using a pre-computed delay PMF
delay <- estimate_delay(rep_tri, n = 30)
retro_pt_nowcast_mat_list <- estimate_and_apply_delays(
  retro_rts,
  n = 30,
  delay_pmf = delay
)
retro_pt_nowcast_mat_list[1:2]
}
\seealso{
High-level workflow wrapper functions
\code{\link{allocate_reference_times}()},
\code{\link{estimate_and_apply_delay}()},
\code{\link{estimate_and_apply_uncertainty}()},
\code{\link{estimate_uncertainty_retro}()}
}
\concept{workflow_wrappers}
