% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_delay.R
\name{estimate_delay}
\alias{estimate_delay}
\title{Estimate a delay distribution from a reporting triangle}
\usage{
estimate_delay(
  reporting_triangle,
  n = nrow(reporting_triangle),
  validate = TRUE
)
}
\arguments{
\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{n}{Integer indicating the number of reference times (observations) to
be used in the estimate of the reporting delay, always starting from the
most recent reporting delay. The default is to use the whole reporting
triangle, so \code{nrow(reporting_triangle)}.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
Vector indexed at 0 of length \code{ncol(reporting_triangle)} with
columns indicating the point estimate of the empirical probability
mass on each delay.
}
\description{
Provides an estimate of the reporting delay as a function
of the delay, based on the reporting triangle and the number of reference
date observations to be used in the estimation. This point estimate of the
delay is computed empirically, using an iterative algorithm starting from
the most recent observations. Use \code{\link[=truncate_to_delay]{truncate_to_delay()}} if you want to
limit the maximum delay before estimation.
This code was adapted from code written (under an MIT license)
by the Karlsruhe Institute of Technology RESPINOW
German Hospitalization Nowcasting Hub.
Modified from: \url{https://github.com/KITmetricslab/RESPINOW-Hub/blob/7cce3ae2728116e8c8cc0e4ab29074462c24650e/code/baseline/functions.R#L55} #nolint
}
\examples{
# Example 1: Standard usage
delay_pmf <- estimate_delay(
  reporting_triangle = example_reporting_triangle
)
delay_pmf

# Example 2: Using data with downward corrections (negatives preserved)
# Low-level functions process triangles as-is without preprocessing
delay_pmf_negative <- estimate_delay(
  reporting_triangle = example_downward_corr_rt,
  n = 5
)
delay_pmf_negative

# Example 3: Preprocess explicitly before estimation if needed
preprocessed_triangle <- preprocess_negative_values(example_downward_corr_rt)
delay_pmf_preprocessed <- estimate_delay(
  reporting_triangle = preprocessed_triangle,
  n = 5
)
delay_pmf_preprocessed
}
\seealso{
Delay distribution estimation functions
\code{\link{preprocess_negative_values}()}
}
\concept{estimate_delay}
