% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{syn_nssp_line_list}
\alias{syn_nssp_line_list}
\title{A synthetic dataset resembling line-list (each row is a patient) data from
the United States' National Syndromic Surveillance System (NSSP)
accessed via the Essence platform. All entries are synthetic, formatted to
look as close to the real raw data as possible.}
\format{
A data.frame with 25 rows and 8 columns.
\describe{
\item{C_Processed_BioSenseID}{Unique identifier for each patient}
\item{CCDDParsed}{Character string indicating primary symptoms and
corresponding diagnoses codes.}
\item{DischargeDiagnosisMDTUpdates}{Character string formatted as a
dictionary with indices and corresponding time stamps formatted as
YYYY-MM-DD HH:MM:SS.}
\item{DischargeDiagnosisUpdates}{Character string formatted as a
dictionary with indices and corresponding diagnoses codes pertaining to
this diagnosis associated with that event.}
\item{HasBeenAdmitted}{Numeric indicating whether the patient was
admitted (0 for no, 1 for admission).}
\item{C_Visit_Date_Time}{Date-time indicating the time stamp of the
the patient registering in the emergency department, in
YYYY-MM-DD HH:MM:SS format.}
\item{c_race}{Character string indicating the race/ethnicity of the
patient.}
\item{sex}{Character string indicating the sex of the patient.}
}
}
\source{
Created for package demonstration to provide an example of how to
pre-process this dataset to obtain a reporting triangle. This is made to
look like the data that one would pull directly an API to access
patient-level line-list data.
}
\usage{
syn_nssp_line_list
}
\description{
For an example of how to produce a nowcast from this data, see
\code{vignette("nssp_nowcast")}.
}
\seealso{
Example datasets
\code{\link{example_downward_corr_rt}},
\code{\link{example_reporting_triangle}},
\code{\link{germany_covid19_hosp}},
\code{\link{syn_nssp_df}}
}
\concept{example_data}
\keyword{datasets}
