% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{geom_borrow}
\alias{geom_borrow}
\title{Plot a Bayesian basket trial's posterior distribution after borrowing}
\usage{
geom_borrow(design, ...)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{...}{Further arguments to be passed to `geom_function`.}
}
\value{
A list of ggplot layers of type `geom_function`.
}
\description{
Plot a Bayesian basket trial's posterior distribution after borrowing
}
\examples{
# Example for a basket trial with Fujikawa's Design
design <- setup_fujikawa(k = 3, p0 = 0.2)
n <- 20
r <- c(4, 5, 2)
epsilon <- 2
tau <- 0.5
# One facet per basket
library(ggplot2)
ggplot() +
    geom_borrow(design, n, r, epsilon, tau, logbase = exp(1)) +
    facet_wrap(vars(basket))
# Colour different baskets
ggplot() +
    geom_borrow(design, n, r, epsilon, tau,
                logbase = exp(1), aes(colour = basket))
}
