% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{posterior_heatmap}
\alias{posterior_heatmap}
\title{Posterior heatmaps for matrix valued parameters}
\usage{
posterior_heatmap(
  x,
  FUN,
  ...,
  transpose = FALSE,
  colorbar = TRUE,
  colorbar_width = 0.1,
  gap_width = 0.25,
  xlabels = NULL,
  ylabels = NULL,
  add_numbers = FALSE,
  zlim = NULL,
  colspace = NULL,
  border_color = NA,
  zero_color = NA,
  main = "",
  detect_lags = TRUE,
  cex.axis = 0.75,
  cex.colbar = 1,
  cex.numbers = 1,
  asp = NULL
)
}
\arguments{
\item{x}{An array of dimension \eqn{a \times b \times draws}, where \eqn{a
  \times b} is the dimension of the parameter to visualize and draws is the
number of posterior draws.}

\item{FUN}{The summary function to be applied to margins \code{c(1,2)} of x. E.g.
\code{"median"}, \code{"mean"}, \code{"IQR"}, \code{"sd"} or \code{"var"}.
\code{apply(x, 1:2, FUN, ...)} must return a matrix!}

\item{...}{optional arguments to \code{FUN}.}

\item{transpose}{logical indicating whether to transpose the matrix or not,
i.e. whether to plot an \eqn{a \times b} or an \eqn{b \times a} matrix.
Default is \code{FALSE}.}

\item{colorbar}{logical indicating whether to display a colorbar or not.
Default is \code{TRUE}.}

\item{colorbar_width}{numeric. A value between 0 and 1 indicating the
proportion of the width of the plot for the colorbar.}

\item{gap_width}{numeric. A value between 0 and 1 indicating the width of the
gap between the heatmap and the colorbar. The width is computed as
\code{gap_width*colorbar_width}.}

\item{xlabels}{\code{ylabels=NULL}, the default, indicates that \code{colnames(x)}
will be displayed. \code{ylabels=""} indicates that no ylabels will be
displayed.}

\item{ylabels}{\code{xlabels=NULL}, the default, indicates that \code{rownames(x)}
will be displayed. \code{xlabels=""} indicates that no ylabels are
displayed.}

\item{add_numbers}{logical. \code{add_numbers=TRUE}, the default indicates
that the actual values of \code{summary} will be displayed.}

\item{zlim}{numeric vector of length two indicating the minimum and maximum
values for which colors should be plotted. By default this range is
determined by the maximum of the absolute values of the selected summary.}

\item{colspace}{Optional argument indicating the color palette to be used. If
not specified, \code{\link[colorspace:hcl_palettes]{colorspace::diverge_hcl()}} will be used, or, if \code{FUN}
returns only positive values \code{\link[colorspace:hcl_palettes]{colorspace::sequential_hcl()}}. See below for
a more detailed description of the default usage.}

\item{border_color}{The color of the rectangles borders. If not specified no
borders will be displayed.}

\item{zero_color}{The color of exact zero elements. By default this is not
specified and then will depend on \code{colspace}.}

\item{main}{main title for the plot.}

\item{detect_lags}{logical. If \code{class(x)} is "bayesianVARs_coef", then
\code{detect_lags=TRUE} will separate the sub matrices corresponding to the lags
with black lines.}

\item{cex.axis}{The magnification to be used for y-axis annotation relative
to the current setting of cex.}

\item{cex.colbar}{The magnification to be used for colorbar annotation
relative to the current setting of cex.}

\item{cex.numbers}{The magnification to be used for the actual values (if
\code{add_numbers=TRUE}) relative to the current setting of cex.}

\item{asp}{aspect ratio.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{posterior_heatmap()} generates a heatmap for draws of matrix values
parameters visualizing point wise summaries, such as mean, median, variance,
standard deviation, interquartile range etc. etc.
}
\details{
\subsection{colspace}{

If not specified either \code{colorspace::diverge_hcl(1001, alpha = alpha, palette = "Blue-Red")} or \code{colorspace::sequential_hcl(1001, alpha = alpha, rev = TRUE, palette = "Reds 2")} will be used.
}
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(100*data, sv_keep = "all", quiet = TRUE)

# Extract posterior draws of VAR coefficients
phi_post <- coef(mod)

# Visualize posterior median of VAR coefficients
posterior_heatmap(phi_post, median, detect_lags = TRUE, border_color = rgb(0, 0, 0, alpha = 0.2))

# Extract posterior draws of variance-covariance matrices (for each point in time)
sigma_post <- vcov(mod)
# Visualize posterior interquartile-range of variance-covariance matrix of the first observation
posterior_heatmap(sigma_post[1,,,], IQR)
}
\seealso{
Other plotting \code{\link[=plot.bayesianVARs_bvar]{plot.bayesianVARs_bvar()}},
\code{\link[=plot.bayesianVARs_fitted]{plot.bayesianVARs_fitted()}}, \code{\link[=plot.bayesianVARs_predict]{plot.bayesianVARs_predict()}},
\code{\link[=pairs.bayesianVARs_predict]{pairs.bayesianVARs_predict()}}.
}
