% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcfrailpar.R
\name{bcfrailpar}
\alias{bcfrailpar}
\title{Parametric bivariate correlated frailty models fit.}
\usage{
bcfrailpar(
  formula,
  data,
  initfrailp = NULL,
  inithazp = NULL,
  initbeta = NULL,
  haz = c("weibull", "gompertz", "exponential"),
  frailty = c("gamma", "invgauss", "pv"),
  comonvar = TRUE,
  ...
)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the Surv function.}

\item{data}{A dataframe contain survival time, censor, covariate etc with data in columns.}

\item{initfrailp}{Initial estimates for the frailty parameters. The default is c(0.5,0.5).}

\item{inithazp}{Initial estimates for the baseline hazard distribution parameters. The default is c(0.05) for both scale and shape parameters.}

\item{initbeta}{Initial estimates for the covariate coefficients if there are any included. The default is taken from coxph fit.}

\item{haz}{A baseline hazard distribution. Either weibull, gompertz or exponential distributions are possible.}

\item{frailty}{A type of frailty distribution. Either gamma, inverse gaussian \code{frailty="invgauss"}  or power variance \code{frailty="pv"} frailty distributions are possible.}

\item{comonvar}{An argument whether to assume common frailty variance. The default is \code{comonvar=TRUE}. If \code{comonvar=FALSE}, then only gamma frailty model is possible.}

\item{...}{further arguments.}
}
\value{
An object of  that contains  the following components.
\itemize{
  \item \code{coefficients} - A vector of estimated Covariate coefficients.
  \item \code{frailparest} - A vector of estimated Frailty parameters i.e. frailty variance and correlation.
  \item \code{basehazpar} - A vector of estimated baseline hazard parameters i.e. scale and shape.
  \item \code{stderr}-A vector containing the Standard errors of the Estimated parameters with the order of frailty parameters,baseline hazard parameters and covariate coefficients.
  \item \code{vcov}- Variance Covariance matrix of the Estimated parameters.
  \item \code{loglik}-Log likelihood of the model.
  \item \code{AIC}-AIC of the model.
  \item \code{BIC}-BIC of the model.
  \item \code{iterations}-Number of outer iterations.See\link{constrOptim} for further.
  \item \code{convergence}-An indicator of convergence. See\link{constrOptim} for further.
  }
}
\description{
Fit a parametric Bivariate correlated gamma, inverse gaussian and power variance frailty models with Proportional Hazard structure.
}
\examples{
set.seed(4)
simdata<-simbcfraildv(psize=500, cenr= c(0.3),beta=c(2),frailty=c("gamma"),
frailpar=c(0.5,0.5,0.5),bhaz=c("weibull"),
bhazpar=list(shape =c(5), scale = c(0.1)),
covartype= c("B"),covarpar=list(fargs=c(1),sargs=c(0.5)))
dataa<-simdata$data

fitbcfrail=bcfrailpar(Surv(time,censor)~ X1+frailty(PID) ,data=dataa,frailty="gamma")
fitbcfrail

\donttest{

set.seed(18)
simdata<-simbcfraildv(psize=300, cenr= c(0.3),beta=c(2),frailty=c("gamma"),
frailpar=c(0.5,0.5,0.4),bhaz=c("weibull"),
bhazpar=list(shape =c(5), scale = c(0.1)),
covartype= c("B"),covarpar=list(fargs=c(1),sargs=c(0.5)))
dataa<-simdata$data

#fit with power variance frailty distribution
fitbcfrail=bcfrailpar(Surv(time,censor)~ X1+frailty(PID) ,data=dataa,
frailty="pv")
fitbcfrail

## one can set the initial parameter for the frailty parameters
fitbcfrail=bcfrailpar(Surv(time,censor)~ X1+frailty(PID) ,data=dataa,initfrailp = c(0.4,0.3),
frailty="gamma")
fitbcfrail

# Not run

#if initial frailty parameters are in the boundary of parameter space
fitmoe=try(bcfrailpar(Surv(time,censor)~ X1+frailty(PID),data=dataa,
initfrailp=c(0.2,1)),silent = TRUE)

#if a frailty distribution other than gamma, invgauss or pv is specified

fitmoe=try(bcfrailpar(Surv(time,censor)~ X1,data=dataa,frailty="exp"),silent = TRUE)

# End Not run
}

}
