% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{brs_gof}
\alias{brs_gof}
\title{Goodness-of-fit measures}
\usage{
brs_gof(object)
}
\arguments{
\item{object}{A fitted \code{"brs"} or \code{"brsmm"} object.}
}
\value{
Data frame with logLik, AIC, BIC, and pseudo-R-squared.
}
\description{
Goodness-of-fit measures
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
brs_gof(fit)
}
}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
\seealso{
\code{\link{brs}}, \code{\link{brs_est}}, \code{\link{brs_hessian}}
}
