% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_calibration.R
\name{ntwoarmbinbf01}
\alias{ntwoarmbinbf01}
\title{Sample size calibration for two-arm binomial Bayes factor designs}
\usage{
ntwoarmbinbf01(
  k = 1/3,
  k_f = 1/3,
  power = 0.8,
  alpha = 0.05,
  pce_H0 = 0.9,
  test = c("BF01", "BF+0", "BF-0", "BF+-"),
  nrange = c(10, 150),
  n_step = 1,
  progress = TRUE,
  compute_freq_t1e = FALSE,
  p1_grid = seq(0.01, 0.99, 0.02),
  p2_grid = seq(0.01, 0.99, 0.02),
  p1_power = NULL,
  p2_power = NULL,
  a_0_d = 1,
  b_0_d = 1,
  a_0_a = 1,
  b_0_a = 1,
  a_1_d = 1,
  b_1_d = 1,
  a_2_d = 1,
  b_2_d = 1,
  a_1_a = 1,
  b_1_a = 1,
  a_2_a = 1,
  b_2_a = 1,
  output = c("plot", "numeric"),
  a_1_d_Hminus = 1,
  b_1_d_Hminus = 1,
  a_2_d_Hminus = 1,
  b_2_d_Hminus = 1,
  a_1_a_Hminus = 1,
  b_1_a_Hminus = 1,
  a_2_a_Hminus = 1,
  b_2_a_Hminus = 1,
  alloc1 = 0.5,
  alloc2 = 0.5
)
}
\arguments{
\item{k}{Evidence threshold for rejecting the null (inverted BF).}

\item{k_f}{Evidence threshold for "compelling evidence" in favour of the null.}

\item{power}{Target Bayesian power.}

\item{alpha}{Target Bayesian type-I error.}

\item{pce_H0}{Target probability of compelling evidence under \eqn{H_0}.}

\item{test}{Character string, one of \code{"BF01"}, \code{"BF+0"},
\code{"BF-0"}, \code{"BF+-"}.}

\item{nrange}{Integer vector of length 2 giving the search range for total n.}

\item{n_step}{Step size for n.}

\item{progress}{Logical; if \code{TRUE}, print progress to the console.}

\item{compute_freq_t1e}{Logical; if \code{TRUE}, compute frequentist
type-I error over a grid.}

\item{p1_grid, p2_grid}{Grids of true proportions for frequentist T1E.}

\item{p1_power, p2_power}{Optional true proportions for frequentist power.}

\item{a_0_d, b_0_d, a_0_a, b_0_a}{Shape parameters for design and analysis priors
under \eqn{H_0}.}

\item{a_1_d, b_1_d, a_2_d, b_2_d}{Shape parameters for design priors under
\eqn{H_1} or \eqn{H_+}.}

\item{a_1_a, b_1_a, a_2_a, b_2_a}{Shape parameters for analysis priors under
\eqn{H_1} or \eqn{H_+}.}

\item{output}{\code{"plot"} or \code{"numeric"}.}

\item{a_1_d_Hminus, b_1_d_Hminus, a_2_d_Hminus, b_2_d_Hminus}{Optional design
priors under \eqn{H_-} for directional tests.}

\item{a_1_a_Hminus, b_1_a_Hminus, a_2_a_Hminus, b_2_a_Hminus}{Shape parameters for analysis priors under H-.}

\item{alloc1, alloc2}{Fixed randomisation probabilities for arm 1 and arm 2;
must be positive and sum to 1. Defaults are 0.5 and 0.5.}
}
\value{
If \code{output = "plot"}, returns invisibly a list with recommended
sample sizes and a ggplot object printed to the device. If
\code{output = "numeric"}, returns a list with recommended n and summary.
}
\description{
Searches over a grid of total sample sizes n to find the smallest n such that
Bayesian power, Bayesian type-I error, and probability of compelling evidence
under H0 meet specified design criteria. Optionally, frequentist type-I error
and power constraints are also evaluated. Unequal fixed randomisation between
the two arms is allowed via alloc1 and alloc2.
}
\examples{
# Standard calibration with equal allocation: power 80\%, type-I 5\%, CE(H0) 80\%
\donttest{
ntwoarmbinbf01(power = 0.8, alpha = 0.05, pce_H0 = 0.8, output = "numeric")
}

# 1:2 allocation (control:treatment) via alloc1 = 1/3, alloc2 = 2/3
\donttest{
ntwoarmbinbf01(power = 0.8, alpha = 0.05, pce_H0 = 0.8,
               alloc1 = 1/3, alloc2 = 2/3, output = "numeric")
}

# BF+0 directional test with plot
\donttest{
ntwoarmbinbf01(power = 0.8, alpha = 0.05, pce_H0 = 0.9,
               test = "BF+0", output = "plot")
}
}
