% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_factors.R
\name{twoarmbinbf01}
\alias{twoarmbinbf01}
\title{Two-arm binomial Bayes factor BF01}
\usage{
twoarmbinbf01(
  y1,
  y2,
  n1,
  n2,
  a_0_a = 1,
  b_0_a = 1,
  a_1_a = 1,
  b_1_a = 1,
  a_2_a = 1,
  b_2_a = 1
)
}
\arguments{
\item{y1}{Number of successes in arm 1 (control).}

\item{y2}{Number of successes in arm 2 (treatment).}

\item{n1}{Sample size in arm 1.}

\item{n2}{Sample size in arm 2.}

\item{a_0_a, b_0_a}{Shape parameters of the Beta prior for the common-\eqn{p}
under the null model.}

\item{a_1_a, b_1_a}{Shape parameters of the Beta prior for \eqn{p_1} under the
alternative.}

\item{a_2_a, b_2_a}{Shape parameters of the Beta prior for \eqn{p_2} under the
alternative.}
}
\value{
Numeric scalar, the Bayes factor BF\eqn{_{01}}.
}
\description{
Computes the Bayes factor BF\eqn{_{01}} comparing the point-null
\eqn{H_0: p_1 = p_2} to the alternative \eqn{H_1: p_1 \neq p_2}
in a two-arm binomial setting with Beta priors.
}
\examples{
twoarmbinbf01(10, 20, 30, 30)
}
