% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_predict.R
\name{predict.bgms}
\alias{predict.bgms}
\title{Predict Conditional Probabilities from a Fitted bgms Model}
\usage{
\method{predict}{bgms}(
  object,
  newdata,
  variables = NULL,
  type = c("probabilities", "response"),
  method = c("posterior-mean", "posterior-sample"),
  ndraws = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{bgms}.}

\item{newdata}{A matrix or data frame with \code{n} rows and \code{p} columns
containing the observed data. Must have the same variables (columns) as
the original data used to fit the model.}

\item{variables}{Which variables to predict. Can be:
\itemize{
  \item A character vector of variable names
  \item An integer vector of column indices
  \item \code{NULL} (default) to predict all variables
}}

\item{type}{Character string specifying the type of prediction:
\describe{
  \item{\code{"probabilities"}}{Return the full conditional probability
    distribution for each variable and observation.}
  \item{\code{"response"}}{Return the predicted category (mode of the
    conditional distribution).}
}}

\item{method}{Character string specifying which parameter estimates to use:
\describe{
  \item{\code{"posterior-mean"}}{Use posterior mean parameters.}
  \item{\code{"posterior-sample"}}{Average predictions over posterior draws.}
}}

\item{ndraws}{Number of posterior draws to use when
\code{method = "posterior-sample"}. If \code{NULL}, uses all available draws.}

\item{seed}{Optional random seed for reproducibility when
\code{method = "posterior-sample"}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For \code{type = "probabilities"}: A named list with one element per
predicted variable. Each element is a matrix with \code{n} rows and
\code{num_categories + 1} columns containing \eqn{P(X_j = c | X_{-j})}{P(X_j = c | X_-j)} for each
observation and category.

For \code{type = "response"}: A matrix with \code{n} rows and
\code{length(variables)} columns containing predicted categories.

When \code{method = "posterior-sample"}, probabilities are averaged over
posterior draws, and an attribute \code{"sd"} is included containing the
standard deviation across draws.
}
\description{
Computes conditional probability distributions for one or more variables
given the observed values of other variables in the data.
}
\details{
For each observation, the function computes the conditional distribution
of the target variable(s) given the observed values of all other variables.
This is the same conditional distribution used internally by the Gibbs
sampler.
}
\examples{
\donttest{
# Fit a model
fit <- bgm(x = Wenchuan[, 1:5], chains = 2)

# Compute conditional probabilities for all variables
probs <- predict(fit, newdata = Wenchuan[1:10, 1:5])

# Predict the first variable only
probs_v1 <- predict(fit, newdata = Wenchuan[1:10, 1:5], variables = 1)

# Get predicted categories
pred_class <- predict(fit, newdata = Wenchuan[1:10, 1:5], type = "response")
}

}
\seealso{
\code{\link{simulate.bgms}} for generating new data from the model.
}
