% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_boost.R
\name{cv_boost_raw}
\alias{cv_boost_raw}
\title{Cross-Validated Component-Wise Gradient Boosting with
Multiple Imputation Performed Inside Each Fold}
\usage{
cv_boost_raw(
  X,
  y,
  k = 5,
  ny = 0.1,
  mstop = 250,
  type = c("gaussian", "logistic"),
  MIBoost = TRUE,
  pool = TRUE,
  pool_threshold = 0,
  impute_args = list(m = 10, maxit = 5, printFlag = FALSE),
  impute_method = NULL,
  use_quickpred = TRUE,
  quickpred_args = list(mincor = 0.1, minpuc = 0.5, method = NULL, include = NULL,
    exclude = NULL),
  seed = 123,
  show_progress = TRUE,
  return_full_imputations = FALSE,
  center = "auto"
)
}
\arguments{
\item{X}{A data.frame or matrix of predictors of size \eqn{n \times p}
containing missing values. Column names are preserved. Rows with missing
outcomes \code{y} are removed before CV. If no missing values are present in
\code{X} after removing missing-\code{y} rows, use
\code{\link{cv_boost_imputed}} instead.}

\item{y}{A vector of length \eqn{n} with the outcome (numeric for
\code{type = "gaussian"}; numeric \code{0/1} or a 2-level factor for
\code{type = "logistic"}). Must align with \code{X} rows. Rows with missing
\code{y} are removed before CV. The outcome is never imputed and is not used
as a predictor in imputation models.}

\item{k}{Number of cross-validation folds. Default is \code{5}.}

\item{ny}{Learning rate. Defaults to \code{0.1}.}

\item{mstop}{Maximum number of boosting iterations to evaluate during
cross-validation. The selected \code{mstop} is the value minimizing
the mean CV error over \code{1:mstop}. Default is \code{250}.}

\item{type}{Type of loss function. One of:
\code{"gaussian"} (mean squared error) for continuous responses,
or \code{"logistic"} (binomial deviance) for binary responses.}

\item{MIBoost}{Logical. If \code{TRUE}, applies the MIBoost algorithm,
which enforces uniform variable selection across all imputed datasets. If
\code{FALSE}, variables are selected independently within each imputed
dataset, and pooling is governed by \code{pool_threshold}.}

\item{pool}{Logical. If \code{TRUE}, models across the \eqn{M} imputed
datasets are aggregated into a single final model. If \code{FALSE},
\eqn{M} separate models are returned.}

\item{pool_threshold}{Only used when \code{MIBoost = FALSE} and
\code{pool = TRUE}. Controls the pooling rule when aggregating the
\eqn{M} models obtained from the imputed datasets into a single final model.
A candidate variable is included only if it is selected in at least
\code{pool_threshold} (a value in (0, 1) proportion of the imputed
datasets; coefficients of all other variables are set to zero. A value of
\code{0} corresponds to estimate-averaging, while values \code{> 0}
correspond to selection-frequency thresholding.}

\item{impute_args}{A named list of arguments forwarded to \code{mice::mice()}
both inside CV and on the full dataset (e.g., \code{m}, \code{maxit},
\code{seed}, \code{printFlag}, etc.). Internally, \code{data},
\code{predictorMatrix}, and \code{ignore} are set by the function and will
override any values supplied here. If \code{m} is missing, a default of
\code{10} is used.}

\item{impute_method}{Optional \emph{named} character vector passed to
\code{mice::mice(method = ...)} to control per-variable methods for
covariates \code{X} (e.g., \code{"pmm"}, \code{"logreg"}). This may be a
\emph{partial} vector: entries are merged by name into a full default method
vector derived from \code{X}; unmatched names are ignored with a warning.
If \code{NULL} (default), numeric covariates use \code{"pmm"}.}

\item{use_quickpred}{Logical. If \code{TRUE} (default), build the
\code{predictorMatrix} via \code{mice::quickpred()} on the training covariates
within each fold; otherwise use \code{mice::make.predictorMatrix()}.}

\item{quickpred_args}{A named list of arguments forwarded to
\code{mice::quickpred()} (e.g., \code{mincor}, \code{minpuc},
\code{method}, \code{include}, \code{exclude}). Ignored when
\code{use_quickpred = FALSE}.}

\item{seed}{Base random seed for fold assignment. If \code{impute_args$seed}
is \emph{not} supplied, this value also seeds imputation; otherwise the
user-specified \code{impute_args$seed} is respected and deterministically
offset per fold. RNG state is restored on exit. Default \code{123}.}

\item{show_progress}{Logical. If \code{TRUE} (default), print progress for
the imputation and boosting phases, plus a summary at completion.}

\item{return_full_imputations}{Logical. If \code{TRUE}, attach the list of
full-data imputations used for the final fit as
\code{$full_imputations = list(X = <list length m>, y = <list length m>)}.
Default is \code{FALSE}.}

\item{center}{One of \code{c("auto", "off", "force")}. Controls centering of
\code{X}. With \code{"auto"} (recommended), centering is applied only if the
training data are not already centered (checked across imputations). With
\code{"force"}, centering is always applied. With \code{"off"}, centering is
skipped.

If centering is applied, a single grand mean vector \eqn{\mu_\star} is
computed from the imputed training covariates in the corresponding fold and
subtracted from all imputed training and validation matrices in that fold
(and analogously for the final model fit on the full-data imputations).}
}
\value{
A list with:
\itemize{
\item \code{CV_error}: numeric vector (length \code{mstop}) of mean CV loss.
\item \code{best_mstop}: integer index minimizing \code{CV_error}.
\item \code{final_model}: numeric vector of length \code{1 + p} with the
intercept and pooled coefficients of the final fit on full-data
imputations at \code{best_mstop}.
\item \code{full_imputations}: (optional) when \code{return_full_imputations=TRUE},
a list \code{list(X = <list length m>, y = <list length m>)} containing
the full-data imputations used for the final model.
\item \code{folds}: integer vector of length \eqn{n} giving the CV fold id
for each observation (1..k).
}
}
\description{
Performs k-fold cross-validation for \code{\link{impu_boost}} on data with
missing values. Within each fold, multiple imputation, centering, model
fitting, and validation are performed in a leakage-avoiding manner to select
the optimal number of boosting iterations (\code{mstop}). The final model is
then fitted on multiple imputations of the full dataset at the selected
stopping iteration.
}
\details{
Rows with missing outcomes \code{y} are removed before fold assignment.
Within each CV fold, the remaining data are first split into a training subset
and a validation subset. Multiple imputation is then performed on the
covariates \code{X} only (the outcome is never imputed and is not used as a
predictor in the imputation models). The training covariates are multiply
imputed \eqn{M} times using \pkg{mice}, producing \eqn{M} imputed training
datasets. The corresponding validation covariates are then imputed \eqn{M}
times using the imputation models learned from the training data (leakage-avoiding).

If centering is applied, a single grand mean vector \eqn{\mu_\star} is
computed from the imputed training covariates in the corresponding fold and
subtracted from \emph{all} imputed training and validation covariate matrices
in that fold.

\code{\link{impu_boost}} is run on the imputed training datasets for up to
\code{mstop} boosting iterations. At each iteration, prediction errors are
computed on the corresponding validation datasets and averaged across
imputations. This yields an aggregated error curve per fold, which is then
averaged across folds. The optimal stopping iteration is chosen as the
\code{mstop} value minimizing the mean CV error.

Finally, the full covariate matrix \code{X} is multiply imputed \eqn{M} times.
If centering is applied, it uses a grand mean \eqn{\mu_\star} computed across
the \eqn{M} full-data imputations. \code{\link{impu_boost}} is applied to these
datasets for the selected number of boosting iterations to obtain the final model.

\strong{Imputation control.} All key \pkg{mice} settings can be passed via
\code{impute_args} (a named list forwarded to \code{mice::mice()}) and/or
\code{impute_method} (a named character vector of per-variable methods).
Internally, the function builds a full default method vector from the actual
data given to \code{mice()}, then \emph{merges} any user-supplied entries
by name. \emph{The names in \code{impute_method} must exactly match the
column names in \code{X} (i.e., the data passed to \code{mice()}).} Partial
vectors are allowed; variables not listed fall back to defaults; unknown names
are ignored with a warning. The function sets and may override \code{data},
\code{method} (after merging overrides), \code{predictorMatrix}, and
\code{ignore} (to enforce train-only learning). Predictor matrices can be built
with \code{mice::quickpred()} (see \code{use_quickpred}, \code{quickpred_args})
or with \code{mice::make.predictorMatrix()}.
}
\examples{
\dontshow{if (requireNamespace("mice", quietly = TRUE) && requireNamespace("miceadds", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
  utils::data(booami_sim)
  X <- booami_sim[, 1:25]
  y <- booami_sim[, 26]

  res <- cv_boost_raw(
    X = X, y = y,
    k = 2, seed = 123,
    impute_args    = list(m = 2, maxit = 1, printFlag = FALSE, seed = 1),
    quickpred_args = list(mincor = 0.30, minpuc = 0.60),
    mstop = 50,
    show_progress = FALSE
  )

  # Partial custom imputation method override (X variables only)
  meth <- c(X1 = "pmm")
  res2 <- cv_boost_raw(
    X = X, y = y,
    k = 2, seed = 123,
    impute_args    = list(m = 2, maxit = 1, printFlag = FALSE, seed = 456),
    quickpred_args = list(mincor = 0.30, minpuc = 0.60),
    mstop = 50,
    impute_method  = meth,
    show_progress = FALSE
  )
  \dontshow{invisible(utils::capture.output(str(res2)))}
}
\dontshow{\}) # examplesIf}
}
\references{
Kuchen, R. (2025). \emph{MIBoost: A Gradient Boosting Algorithm for Variable
Selection After Multiple Imputation}. arXiv:2507.21807.
\doi{10.48550/arXiv.2507.21807} \url{https://arxiv.org/abs/2507.21807}.
}
\seealso{
\code{\link{impu_boost}}, \code{\link{cv_boost_imputed}}, \pkg{mice}
}
