% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_add_suffix.R
\name{addSuffix}
\alias{addSuffix}
\alias{addSuffix,parameters,character,character-method}
\alias{addSuffix,code_records,character,character-method}
\alias{addSuffix,code_record,character,character-method}
\alias{addSuffix,compartments,character,character-method}
\alias{addSuffix,campsis_model,character,character-method}
\title{Generic function to add a suffix to various objects like parameters, code records,
compartment names or a model (all previous objects at the same time).
This makes it an extremely powerful function to combine 2 models or more (using function 'add'),
that have similar equation, parameter or compartment names.}
\usage{
addSuffix(object, suffix, separator = NULL, ...)

\S4method{addSuffix}{parameters,character,character}(object, suffix, separator = NULL, ...)

\S4method{addSuffix}{code_records,character,character}(object, suffix, separator = NULL, ...)

\S4method{addSuffix}{code_record,character,character}(object, suffix, separator = NULL, ...)

\S4method{addSuffix}{compartments,character,character}(object, suffix, separator = NULL, ...)

\S4method{addSuffix}{campsis_model,character,character}(object, suffix, separator = NULL, ...)
}
\arguments{
\item{object}{generic object}

\item{suffix}{suffix to be appended, single character value}

\item{separator}{separator to use before the suffix, default is the underscore}

\item{...}{extra arguments like 'model' if the changes need to be reflected in the model}
}
\value{
updated object of the same class as the provided object, unless 'model' was specified, in that case the model is returned
}
\description{
Generic function to add a suffix to various objects like parameters, code records,
compartment names or a model (all previous objects at the same time).
This makes it an extremely powerful function to combine 2 models or more (using function 'add'),
that have similar equation, parameter or compartment names.
}
