% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-docs.R
\name{log_deviation_from_diagonality}
\alias{log_deviation_from_diagonality}
\title{Log deviation from diagonality}
\usage{
log_deviation_from_diagonality(S_cube, nval, B)
}
\arguments{
\item{S_cube}{Numeric 3D array of shape \verb{p x p x n} containing covariance
matrices in its slices.}

\item{nval}{Numeric vector of length \code{n} giving weights for each matrix.}

\item{B}{Numeric \verb{p x p} orthonormal matrix applied to the covariance slices.}
}
\value{
Numeric scalar value equal to
\eqn{\sum_i n_i (\log \det \operatorname{diag}(B^\top S_i B)
  - \log \det(B^\top S_i B)) / (\sum_i n_i)}.
}
\description{
Evaluates the Flury-Gautschi log-deviation criterion for a collection of
covariance matrices transformed by a loading matrix.
}
\examples{
covs <- array(diag(2), dim = c(2, 2, 1))
log_deviation_from_diagonality(covs, 1, diag(2))
}
