% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-caugi.R
\name{caugi_deserialize}
\alias{caugi_deserialize}
\title{Deserialize caugi Graph from JSON String}
\usage{
caugi_deserialize(json, lazy = FALSE)
}
\arguments{
\item{json}{Character string containing the JSON representation.}

\item{lazy}{Logical; if \code{FALSE} (default), the graph is built immediately.
If \code{TRUE}, graph building is deferred until needed.}
}
\value{
A \code{caugi} object.
}
\description{
Converts a JSON string in the native caugi format back to a caugi graph.
This is a lower-level function; consider using \code{read_caugi()} for
reading from files.
}
\examples{
cg <- caugi(A \%-->\% B, class = "DAG")
json <- caugi_serialize(cg)
cg2 <- caugi_deserialize(json)

}
\seealso{
Other export: 
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
