% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-caugi.R
\name{write_caugi}
\alias{write_caugi}
\title{Write caugi Graph to File}
\usage{
write_caugi(x, path, comment = NULL, tags = NULL)
}
\arguments{
\item{x}{A \code{caugi} object or an object coercible to \code{caugi}.}

\item{path}{Character string specifying the file path.}

\item{comment}{Optional character string with a comment about the graph.}

\item{tags}{Optional character vector of tags for categorizing the graph.}
}
\value{
Invisibly returns the input \code{x}.
}
\description{
Writes a caugi graph to a file in the native caugi JSON format.
This format is designed for reproducibility, caching, and sharing
caugi graphs across R sessions.
}
\details{
The caugi format is a versioned JSON schema that captures:
\itemize{
\item Graph structure (nodes and edges with their types)
\item Graph class (DAG, PDAG, ADMG, UG, etc.)
\item Optional metadata (comments and tags)
}

Edge types are encoded using their DSL operators (e.g., \code{"-->"}, \code{"<->"}, \code{"--"}).

For a complete guide to the format, see \code{vignette("serialization", package = "caugi")}.
The formal JSON Schema is available at:
\url{https://caugi.org/schemas/caugi-v1.schema.json}
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  C \%-->\% D,
  class = "DAG"
)

# Write to file
tmp <- tempfile(fileext = ".caugi.json")
write_caugi(cg, tmp, comment = "Example DAG")

# Read back
cg2 <- read_caugi(tmp)
identical(edges(cg), edges(cg2))

# Clean up
unlink(tmp)

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
