% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thumbnail.R
\name{get_thumbnail}
\alias{get_thumbnail}
\title{Get content item thumbnail}
\usage{
get_thumbnail(content, path = NULL)
}
\arguments{
\item{content}{A content item.}

\item{path}{Optional. A path to a file used to write the thumbnail image. If
no path is provided, a temporary file with the correct file extension is
created.}
}
\value{
The path to the downloaded image file, if \code{content} has a thumbnail; otherwise \code{NA}.
}
\description{
Download the thumbnail for a content item on Connect to a file on your
computer.
}
\examples{
\dontrun{
client <- connect()
item <- content_item(client, "8f37d6e0-3395-4a2c-aa6a-d7f2fe1babd0")
thumbnail <- get_thumbnail(item)
}

}
\seealso{
Other thumbnail functions: 
\code{\link{delete_thumbnail}()},
\code{\link{has_thumbnail}()},
\code{\link{set_thumbnail}()}

Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_associations}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{lock_content}()},
\code{\link{permissions}},
\code{\link{search_content}()},
\code{\link{set_integrations}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
\concept{thumbnail functions}
