% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intToPOSIX.R
\name{intToPOSIX}
\alias{intToPOSIX}
\title{Reverse as.numeric command that is performed on a vector of type POSIXct}
\usage{
intToPOSIX(timeVector, tz = "GMT")
}
\arguments{
\item{timeVector}{A vector of integers produced by as.numeric applied to a
PSIXct vector}

\item{tz}{Time zone of the vector (see \code{\link{as.POSIXct}}).}
}
\value{
POSIXct vector
}
\description{
Takes integer value produced by \code{as.numeric(x)}, where \code{x} is a
POSIXct vector and returns it to a POSIXct vector
}
\note{
There is no check that as.numeric applied to a POSIX vector produced
\code{timeVector}.  So, caution is required in using this function. It was
included simply because I have found it useful
}
\examples{

#library(crawl)
timeVector <- as.numeric(Sys.time())
timeVector
intToPOSIX(timeVector, tz="")
}
\author{
Devin S. Johnson
}
