% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{OpeningMinDose-class}
\alias{OpeningMinDose-class}
\alias{.OpeningMinDose}
\alias{OpeningMinDose}
\alias{.DefaultOpeningMinDose}
\title{\code{OpeningMinDose}}
\usage{
OpeningMinDose(min_dose = 0)

.DefaultOpeningMinDose()
}
\arguments{
\item{min_dose}{(\code{number})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{OpeningMinDose}} opens a backfill cohort when the
cohort's dose is above or equal to the minimum dose specified.
Note that the next recommended dose is not taken into account.
}
\section{Slots}{

\describe{
\item{\code{min_dose}}{(\code{number})\cr the minimum dose at which backfill
cohorts can be opened.}
}}

\note{
Typically, end users will not use the \code{.DefaultOpeningMinDose()} function.
}
\examples{
# Opening backfill cohort when dose is at least 50
my_opening <- OpeningMinDose(min_dose = 50)
}
\seealso{
\code{\link{Opening}} and the other subclasses listed in there.
}
