% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.ct.R
\name{s3}
\alias{s3}
\title{Symmetric sandwich smoother}
\usage{
s3(Y, B, P, lambda = exp(-10:20))
}
\arguments{
\item{Y}{a square symmetric matrix}

\item{B}{a B-spline basis evaluation matrix}

\item{P}{a penalty matrix}

\item{lambda}{a vector of smoothing parameter values}
}
\value{
A list with components
\item{gcv}{generalized cross-validation (GCV) criterion for each value of \code{lambda}}
\item{bestlam}{value of \code{lambda} minimizing the GCV}
\item{coefmat}{matrix of tensor product B-spline coefficients}
\item{Yhat}{the smoothed version of \code{Y}}
}
\description{
This function is used by \code{\link{mds.ct}} to fit a symmetric version of 
the sandwich smoother of Xiao et al. (2013).
}
\examples{
# see example for mds.ct (which calls s3)
}
\references{
Xiao, L., Li, Y. & Ruppert, D. (2013). Fast bivariate P-splines: the sandwich smoother.
\emph{Journal of the Royal Statistical Society Series B}, 75(3), 577–599.
}
\seealso{
\code{\link{mds.ct}}
}
\author{
Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
