% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_sample_balance.R
\name{sample_balance}
\alias{sample_balance}
\title{Class balancing (up/down sampling)}
\usage{
sample_balance(attribute, method = c("down", "up"), seed = NULL)
}
\arguments{
\item{attribute}{target class attribute name}

\item{method}{balancing method: "down" or "up"}

\item{seed}{optional random seed for reproducibility}
}
\value{
returns an object of class \code{sample_balance}
}
\description{
Balance class distribution using up-sampling or down-sampling.
}
\examples{
data(iris)
iris_imb <- iris[iris$Species != "setosa", ]
sb <- sample_balance("Species", method = "down", seed = 123)
iris_bal <- transform(sb, iris_imb)
table(iris_bal$Species)
}
