% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_matrix_addChart}
\alias{e_matrix_addChart}
\title{Add new chart to matrix chart}
\usage{
e_matrix_addChart(
  e,
  chart,
  coord,
  id = "chart1",
  legend = TRUE,
  legend_pos = "bottom",
  legend_space = "0\%",
  margin_trbl = c(t = "5\%", r = "5\%", b = "15\%", l = "5\%")
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{chart}{An existing echart that you want to attach to your new matrix
chart}

\item{coord}{X,Y Coordinate of matrix to place your new chart. Charts can
cover multiple coordinates such as `list(c(0,1),0)`. See
\href{https://echarts.apache.org/en/option.html#matrix.body.data.coord}{Matrix
Coordinates} for more information on matrix coordinates.}

\item{id}{Unique id value that will be added when chart is placed in the
matrix. Defaults to `"chart1"`}

\item{legend}{Whether chart contains a legend. Defaults to \code{TRUE}.}

\item{legend_pos}{Position of the legend. One of "top", "right", "bottom",
"left". Determines to which side the `legend_space` argument applies.}

\item{legend_space}{Space between legend and plot area. Supports
integers(pixels) or strings(percent of parent cell).}

\item{margin_trbl}{Adjusts the size of the outside margin around the plotting
area. Default is `c(t = "15%", r = "5%", b = "5%", l = "5%")`. Supports
integers(pixels) or strings(percent of parent cell) To change only e.g. two
sides `c("r" = 8, "l" = 8)` could be used, other sides will use defaults.}
}
\description{
Adds an already existing echart to your new matrix chart. Charts with timelines are not supported.
}
\examples{
echart <- iris |>
group_by(Species) |>
  e_charts(Sepal.Length) |>
  e_line(Sepal.Width) |>
  e_tooltip(trigger = "axis")

e_matrix_raw(rows = 3, cols = 3, body = list(
itemStyle = list(borderWidth = 0))) |>
e_matrix_addChart(echart, coord = list(
   c(0,2),0), margin_trbl = c("b" = "20\%"))


}
